/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */
'use strict';

// Jasmine Unit Testing Suite
define([ "jquery", "backbone", "marionette", "Portal",
    "loader",
    "jquerymobile", "jasminejquery" ],
    function ($, Backbone, Marionette, Portal) {

        describe("Search Applet: Title", function () {
            var view,
                viewEl,
                model = new Backbone.Model({
                    title: 'Patient Search',
                    searchType: 'patient'
                });

            beforeEach(function () {
                view = new Portal.ListGenerator.TitleView({
                    model: model
                });
                viewEl = view.render().$el;
            });
            afterEach(function() {
                viewEl.remove();
            });

            it("shows the search title", function () {
                expect(viewEl.text()).toEqual("Patient Search");
            });
            it("updates the search title", function () {
                view.model.set('title', 'Another Search');
                expect(viewEl.text()).toEqual("Another Search");
            });
        });
    });